//OS: Windows 7
//Scilab Version: Scilab 5.4.1
//two dimensional cosine transform
clc;
clear all;
f=[2 4 4 2;4 6 8 3;2 8 10 4;3 8 6 2];//Input: Enter a square matrix
//Input ex. f=[2 4 4 2;4 6 8 3;2 8 10 4;3 8 6 2]
[M N]=size(f);//finding length of input sequence
for k=1:N
    for n=1:N
        if (k-1)==0
           C(k,n)=inv(sqrt(N));//cosine transform matrix 
        else
           C(k,n)=sqrt(2)*inv(sqrt(N))*cos(%pi*(2*(n-1)+1)*(k-1)/(2*N));
        end
    end
end

F=C*f*C';//discrete cosine transform of input for non-symmetric DCT 
disp(F,"is",f,"Two dimensional cosine transform of");//Output: Two dimensional cosine transform of the matrix
//Output for ex. :
//    19.        - 0.2705981  - 8.           0.6532815  
//  - 2.6923823  - 0.25         2.3096988    0.8964466  
//  - 3.5          1.4650756    1.5        - 1.6892464  
//    0.0328290  - 1.6035534  - 0.9567086  - 0.25 
